create database Film;

use Film;


create table Osoba
(
	IDOsoba int primary key,
	Ime nvarchar(50),
	Prezime nvarchar(50)
);

create table VrstaUloge
(
	IDVrstaUloge int primary key not null,
	Naziv nvarchar(50)
);

create table Zanr
(
	IDZanr int primary key,
	Naziv nvarchar(100)
);

create table Film
(
	IDFilm bigint not null primary key,
	Naziv nvarchar(100) not null,
	ZanrID int not null,
	foreign key (ZanrID) references Zanr(IDZanr)
);

create table Uloga
(
	IDUloga int primary key not null,
	OsobaID int not null,
	VrstaUlogeID int not null,
	FilmID bigint not null,
	foreign key(OsobaID) references Osoba(IDOsoba),
	foreign key(VrstaUlogeID) references VrstaUloge(IDVrstaUloge),
	foreign key(FilmID) references Film(IDFilm)
);

create table VrstaMedija
(
	IDVrstaMedija int primary key,
	Naziv nvarchar(100) not null,
);

create table FizickiMedij
(
	IDFizickiMedij int primary key,
	Sifra nvarchar(20),
	VrstaMedijaID int not null
	foreign key(VrstaMedijaID) references VrstaMedija(IDVrstaMedija),
);

create table Clan
(
	IDClan bigint not null primary key,
	Ime nvarchar(100) not null,
	Prezime nvarchar(100) not null
);

create table Posudba
(
	IDPosudbe bigint primary key,
	FilmID bigint not null,
	FizickiMedijID int not null,
	ClanID bigint not null,
	DatumPosudbe date not null,
	RokZaVracanje date not null,
	DatumVracanja date null,
	Zakasnina decimal(7,2) null,
	foreign key(FilmID) references Film(IDFilm),
	foreign key(FizickiMedijID) references FizickiMedij(IDFizickiMedij),
	foreign key(ClanID) references Clan(IDClan)
);